# buatapa autorun output digester 
#
# Directions:
# Run buatapa.py and wait for the the script to finish
#
# Version 0.0.7 - 30 Jan 18 - Minor bug fixes, improved error handling. Added more robust feedback to output. Tabs vs spaces
# Version 0.0.6 - 11 Nov 15 - Added API query for threatcrowd. Added parsing for autoruns generated by autoruns 13.5
# Version 0.0.5 - 26 Aug 15 - Added output for a submitted file with zero results. Modified screen and file output to reflect these changes
# Version 0.0.4 - 25 Jun 15 - Added output to screen in the event the same hash is seen multiple times in file. Added --full flag to process all hashes, regardless of if the signature is verified or not.
# Version 0.0.3 - 03 Apr 15 - Changed Unicode character detection to Windows cp1252 to try to eliminate false positives on non-English systems. Added --unicode flag to detect non-ASCII entries (turned OFF by default)
# Version 0.0.2 - 01 Apr 15 - Added abnormal Unicode character detection
# Version 0.0.1 - 30 Mar 15 - @brianjmoran - brian@brimorlabs.com
#
# TODO:
# 

from __future__ import print_function

import codecs
import fileinput
import hashlib
import io
import os
import re
import subprocess
import sys
import time
import csv
from argparse import ArgumentParser
from datetime import datetime
from string import whitespace
from time import sleep
from traceback import format_exc
reload(sys)
sys.setdefaultencoding('utf8')

try:
	import requests
	has_internet = True
except ImportError:
	has_internet = False
	print('[!] Python module "requests" not found. Internet functionality is now disabled.')


# The below are customizable variables. Change these as you see fit.
generalize_paths = True  # Generalize paths to their base environment variable
debug = False
#Take a look at timeout seconds

timeout_seconds = 0      # Set to 0 to manually end monitoring with Ctrl-C

virustotal_api_key = ''   ## Set API here
if os.path.exists(''):    ## Or put it in here
	virustotal_api_key = open('virustotal.api', 'r').readline().strip()


### Below are global internal variables. Do not edit these. #############
__VERSION__ = '0.0.7 (Build 20180130)'                                  #
__AUTHOR__ = 'Brian Moran (@brianjmoran)'                               #
__EMAIL__ = 'brian@brimorlabs.com'                                      #
__ENDOFLINE__ = '\n----- End of Line -----\n\n'                         #
path_general_list = []                                                  #
has_virustotal = True if virustotal_api_key else False                  #
virustotal_upload = True if virustotal_api_key else False               #
use_virustotal = True if virustotal_api_key and has_internet else False #
vt_results = {}                                                         #
tc_results = {}                                                         #
exe_cmdline = ''                                                        #
time_exec = 0                                                           #
time_process = 0                                                        #
time_analyze = 0                                                        #
suspentry_count = 0                                                     #
vtquery_count = 0                                                       #
tcquery_count = 0                                                       #
num_lines = 0                                                           #
verified_count = 0														#
nonunicodedetected = ''                                                 #
find_unicode = ''                                                       #
process_all_hashes = 'no'                                               #
scan_with_no_results = ''                                               #
autorunsversion = ''                                                    #
sha256 = ''                                                             #
#########################################################################


	
#Making sure the file exists			
def file_exists(fname):
    """
    Determine if a file exists

    Arguments:
        fname: path to a file
    Results:
        boolean value if file exists
    """
    accesscheck=os.access(fname, os.R_OK)
    if accesscheck == 1:
        return os.path.exists(fname) and os.access(fname, os.R_OK)
    else:	
        print('*****WARNING! WARNING!*****\nCould not open file \"%s\". Please check file permissions and try again\n' % fname)
        sys.exit(1)

def open_file_with_assoc(fname):
    """
    Opens the specified file with its associated application

    Arguments:
        fname: full path to a file to open
    Results:
        None
    """
    if os.name == 'mac':
        subprocess.call(('open', fname))
    elif os.name == 'nt':
        os.startfile(fname)
    elif os.name == 'posix':
        subprocess.call(('open', fname))
	

def generalize_var(path_string):
    """
    Generalize a given string to include its environment variable

    Arguments:
        path_string: string value to generalize
    Results:
        string value of a generalized string
    """
    if not len(path_general_list):
        generalize_vars_init()  # Maybe you imported buatapa and forgot to call generalize_vars_init? No biggie.
    for item in path_general_list:
        path_string = re.sub(item[1], item[0], path_string)
    return path_string

def virustotal_query_hash(hash):
    """
    Submit a SHA256 hash to VirusTotal to retrieve number of alerts
    """
    global vt_results
    global scan_with_no_results
    try:
        if not (len(hash) == 64 and int(hash, 32)):
            return None
    except (TypeError, ValueError):
        pass

    try:
        previous_result = vt_results[hash]
        if debug:
            print('[-] VT scan already performed for %s. Returning previous: %s' % (hash, previous_result))
        print('[-] VT scan already performed for %s. Moving along.' % hash)		
        return previous_result
    except KeyError:
        pass     
    vt_query_url = 'https://www.virustotal.com/vtapi/v2/file/report'
    post_params = {'apikey': virustotal_api_key,
                   'resource': hash}
    print('[*] Querying VirusTotal for hash: %s' % hash)
    time.sleep(15)
    global vtquery_count
    vtquery_count = vtquery_count +1
    data = ''
    http_response = requests.post(vt_query_url, post_params)
    
    if http_response.status_code == 204:
        print('[!] VirusTotal Rate Limit Exceeded. Sleeping for 60 seconds.')
        time.sleep(60)
        return virustotal_query_hash(hash)
    else:
        try:
            data = http_response.json()
            #print("%s\n" % data)
        except ValueError:
            result = 'Error'
        try:
            if data['response_code'] == -2:
                result = '[VT: Queued]'
            elif data['response_code'] == -1:
                result = '[VT: Error 001]'
            elif data['response_code'] == 0:
                result = '[This file has not been (yet) uploaded to VirusTotal]\r\n'
            elif data['response_code'] == 1:
                if data['positives'] == 1:
                    print ("[!] The file %s was detected by %s AV scanner" % (hash, (data['positives'])))
                    result = "This file was detected by %s AV scanner\r\nURL: %s\r\nScanDate: %s" % (data['positives'], data['permalink'], data['scan_date'])
                elif data['positives'] > 1:
                    print ("[!] The file %s was detected by %s AV scanners" % (hash, (data['positives'])))
                    result = "This file was detected by %s AV scanners\r\nURL: %s\r\nScanDate: %s" % (data['positives'], data['permalink'], data['scan_date'])
                elif data['positives'] == 0:
                    result = "The file %s WAS NOT detected by %s AV scanners\r\nURL: %s\r\nScanDate: %s" % (hash, data['total'], data['permalink'], data['scan_date'])
                    scan_with_no_results="[*] The file %s WAS NOT detected by %s AV scanners on %s" % (hash, (data['total']), (data['scan_date']))
                else:
                    result = ' [VT: Error 002]'
        except TypeError:
            result = ' [VT: Error 003]'
    vt_results[hash] = result
    return result


def threatcrowd_query_hash(tchash):
    """
    Submit a MD5 hash to threatcrowd to determine if it has been seen
    """
    global tc_results
    global scan_with_no_results
    global sha256
    try:
        if not (len(tchash) == 32 and int(tchash, 16)):
            return None
    except (TypeError, ValueError):
        pass

    try:
        tcprevious_result = tc_results[tchash]
        if debug:
            print('[-] TC scan already performed for %s. Returning previous: %s' % (sha256, tcprevious_result))
        print('[-] TC scan already performed for %s. Moving along.' % sha256)		
        return tcprevious_result
    except KeyError:
        pass     
    tchttp_response =  requests.get("https://www.threatcrowd.org/searchApi/v2/file/report/", params = {"resource": tchash})
    print('[*] Querying ThreatCrowd for hash: %s' % sha256)
    global tcquery_count
    tcquery_count = tcquery_count +1
    tcdata = ''
    
    if tchttp_response.status_code == 204:
        print('[!] ThreatCrowd Rate Limit Exceeded. Sleeping for 60 seconds.')
        time.sleep(60)
        return threatcrowd_query_hash(tchash)
    else:
        try:
            tcdata = tchttp_response.json()
        except ValueError:
            tcresult = 'Error'
        try:
            if tcdata['response_code'] == "-2":
                tcresult = '[TC: Queued]'
            elif tcdata['response_code'] == "-1":
                tcresult = '[TC: Error 001]'
            elif tcdata['response_code'] == "0":
                tcresult = 'This file has not (yet) been seen on ThreatCrowd\r\n'
            elif tcdata['response_code'] == "1":
                print ("[!] The file %s was seen on ThreatCrowd" % sha256)
                tcresult = "This file was seen on ThreatCrowd\r\nThreatCrowd URL: %s\r\n" % tcdata['permalink']
            else:
                tcresult = ' [TC: Error 002]'

        except TypeError:
            tcresult = ' [TC: Error 003]'
    tc_results[tchash] = tcresult
    return tcresult

def parse_csv(csv_file, report):
    """
    Given the location of CSV file generated by autoruns, parse the CSV for notable items

    Arguments:
        csv_file: path to csv output to parse
    Results:
        report: string text containing the entirety of the text report
    """
    global suspentry_count
    global num_lines
    global nonunicodedetected
    global autorunsversion
    global sha256
    global verified_count
    nonunicodedetected=''
    vthashes_output = list()
    susp_output = list()
    error_output = list()
    print('[*] Processing CSV: %s' % csv_file)
    
    time_parse_csv_start = time.time()

    # Use fileinput.input() now to read data line-by-line
	
    for num_lines, original_line in enumerate(io.open(csv_file, encoding='utf-16')):
        line = original_line.strip(whitespace + '"')
        uncline = line.encode('utf-8')
        uncline=uncline.replace(', ',' ') #Trying to account for commas and spaces so it doesn't inadvertently split
        uncline=uncline.replace(' ,',' ') #Trying to account for commas and spaces so it doesn't inadvertently split
        field = uncline.strip().split(",")
        server = ''
		
        if find_unicode == "yes":
            try:
                line.decode('ascii')
            except UnicodeDecodeError:
                nonunicodedetected="yes"
                print('[!] Detected non-ASCII characters in data associated with file: %s' % field[15]) #Printing a nice message 
                nonunicodedetected="yes"
            else:
                nonunicodedetected="no"
        else:
            try:
                line.decode('WINDOWS_1252')
            except UnicodeDecodeError:
                nonunicodedetected="yes"
                print('[!] Detected possible abnormal characters in data associated with file: %s' % field[15]) #Printing a nice message
                nonunicodedetected="yes"
            else:
                nonunicodedetected="no"

        try:
            if len(field[0]) == 4 and "MD5" not in line and "SHA-256" not in line:
                print('[!] Unrecognized autoruns header line. Please ensure you ran autoruns with the correct flags and try again. The script will now exit.\n')
                sys.exit(1)
            elif len(field[0]) == 4:
                print('[*] Detected header line. Moving along')
            elif len(field[0]) == 0:
                print('[!] Detected malformed autorun entry. Moving along')
            elif len(field[12]) == 32 and len(field[13]) == 40 and len(field[14]) == 40 and len(field[15]) == 64 and len(field[16]) == 64:
                autorunsversion="thirteenpointfive"
            elif len(field[11]) == 32 and len(field[12]) == 40 and len(field[13]) == 40 and len(field[14]) == 64 and len(field[15]) == 64:
                autorunsversion="priortothirteenpointfive"
#				Take a look at this particular section if needed to account for autoruns formatting change
#             elif len(field[11]) == 32 and len(field[12]) == 40 and len(field[13]) == 40 and len(field[14]) == 64 and len(field[15]) == 64:
#                 autorunsversion="tbd"
            else:
				autorunsversion="unknown"
        except IndexError:
            if debug:
                sys.stderr.write(line)
                sys.stderr.write(format_exc())
                error_output.append(original_line.strip())
			
        try:
            if process_all_hashes == "yes" and len(field[15]) == 64 and autorunsversion == "priortothirteenpointfive":
                sha256 = field[15]
                md5 = field[11]		
                if has_virustotal and has_internet:
                    av_hits = virustotal_query_hash(sha256)
                    tc_hits = threatcrowd_query_hash(md5)
                    if "This file was detected by" in av_hits and nonunicodedetected == "yes":
                         badunicode="This Registry entry under the path %s appears to contain abnormal characters" % (field[1])
                         outputtext = "%s\r\n%s\r\nTime: %s\r\nEntry Location: %s\r\nEntry: %s\r\nEnabled: %s\r\nCategory: %s\r\nProfile: %s\r\nDescrption: %s\r\nPublisher: %s\r\nFilePath: %s\r\nVersion: %s\r\nLaunchString: %s\r\nMD5: %s\r\nSHA1: %s\r\nPESHA1: %s\r\nPESHA256: %s\r\nSHA256: %s\r\nIMPHASH: %s\r\nThreatCrowd Results: %s\r\n\r\n\r\n" % (badunicode, av_hits, field[0], field[1], field[2], field[3], field[4], field[5], field[6], field[7], field[8], field[9], field[10], field[11], field[12], field[13], field[14], field[15], field[16], tc_hits,)
                         susp_output.append(outputtext)
                         suspentry_count = suspentry_count + 1
                    elif "This file was detected by" in av_hits and nonunicodedetected == "no":
                         outputtext = "%s\r\nTime: %s\r\nEntry Location: %s\r\nEntry: %s\r\nEnabled: %s\r\nCategory: %s\r\nProfile: %s\r\nDescrption: %s\r\nPublisher: %s\r\nFilePath: %s\r\nVersion: %s\r\nLaunchString: %s\r\nMD5: %s\r\nSHA1: %s\r\nPESHA1: %s\r\nPESHA256: %s\r\nSHA256: %s\r\nIMPHASH: %s\r\nThreatCrowd Results: %s\r\n\r\n\r\n" % (av_hits, field[0], field[1], field[2], field[3], field[4], field[5], field[6], field[7], field[8], field[9], field[10], field[11], field[12], field[13], field[14], field[15], field[16], tc_hits,)
                         susp_output.append(outputtext)
                         suspentry_count = suspentry_count + 1
                    elif nonunicodedetected == "yes":
                         print('%s' % scan_with_no_results)
                         badunicode="This Registry entry under the path %s appears to contain abnormal characters" % (field[1])
                         outputtext = "%s\r\n%s\r\nTime: %s\r\nEntry Location: %s\r\nEntry: %s\r\nEnabled: %s\r\nCategory: %s\r\nProfile: %s\r\nDescrption: %s\r\nPublisher: %s\r\nFilePath: %s\r\nVersion: %s\r\nLaunchString: %s\r\nMD5: %s\r\nSHA1: %s\r\nPESHA1: %s\r\nPESHA256: %s\r\nSHA256: %s\r\nIMPHASH: %s\r\nThreatCrowd Results: %s\r\n\r\n\r\n" % (badunicode, av_hits, field[0], field[1], field[2], field[3], field[4], field[5], field[6], field[7], field[8], field[9], field[10], field[11], field[12], field[13], field[14], field[15], field[16], tc_hits,)
                         susp_output.append(outputtext)
                         suspentry_count = suspentry_count + 1
                    elif "WAS NOT detected by" in av_hits:
                         print('%s' % scan_with_no_results)
                         outputtext = "%s\r\n\r\n\r\n" % (av_hits)
                         susp_output.append(outputtext)
                elif nonunicodedetected == "yes":
                    badunicode="This Registry entry under the path %s appears to contain abnormal characters" % (field[1])
                    outputtext = "%s\r\nTime: %s\r\nEntry Location: %s\r\nEntry: %s\r\nEnabled: %s\r\nCategory: %s\r\nProfile: %s\r\nDescrption: %s\r\nPublisher: %s\r\nFilePath: %s\r\nVersion: %s\r\nLaunchString: %s\r\nMD5: %s\r\nSHA1: %s\r\nPESHA1: %s\r\nPESHA256: %s\r\nSHA256: %s\r\nIMPHASH: %s\r\nThreatCrowd Results: %s\r\n\r\n\r\n" % (badunicode, field[0], field[1], field[2], field[3], field[4], field[5], field[6], field[7], field[8], field[9], field[10], field[11], field[12], field[13], field[14], field[15], field[16], tc_hits,)
                    susp_output.append(outputtext)
                    suspentry_count = suspentry_count + 1
            elif "Verified" not in field[7]  and len(field[15]) == 64 and autorunsversion == "priortothirteenpointfive":
                sha256 = field[15]
                md5 = field[11]		
                if has_virustotal and has_internet:
                    av_hits = virustotal_query_hash(sha256)
                    tc_hits = threatcrowd_query_hash(md5)
                    if "This file was detected by" in av_hits and nonunicodedetected == "yes":
                         badunicode="This Registry entry under the path %s appears to contain abnormal characters" % (field[1])
                         outputtext = "%s\r\n%s\r\nTime: %s\r\nEntry Location: %s\r\nEntry: %s\r\nEnabled: %s\r\nCategory: %s\r\nProfile: %s\r\nDescrption: %s\r\nPublisher: %s\r\nFilePath: %s\r\nVersion: %s\r\nLaunchString: %s\r\nMD5: %s\r\nSHA1: %s\r\nPESHA1: %s\r\nPESHA256: %s\r\nSHA256: %s\r\nIMPHASH: %s\r\nThreatCrowd Results: %s\r\n\r\n\r\n" % (badunicode, av_hits, field[0], field[1], field[2], field[3], field[4], field[5], field[6], field[7], field[8], field[9], field[10], field[11], field[12], field[13], field[14], field[15], field[16], tc_hits,)
                         susp_output.append(outputtext)
                         suspentry_count = suspentry_count + 1
                    elif "This file was detected by" in av_hits and nonunicodedetected == "no":
                         outputtext = "%s\r\nTime: %s\r\nEntry Location: %s\r\nEntry: %s\r\nEnabled: %s\r\nCategory: %s\r\nProfile: %s\r\nDescrption: %s\r\nPublisher: %s\r\nFilePath: %s\r\nVersion: %s\r\nLaunchString: %s\r\nMD5: %s\r\nSHA1: %s\r\nPESHA1: %s\r\nPESHA256: %s\r\nSHA256: %s\r\nIMPHASH: %s\r\nThreatCrowd Results: %s\r\n\r\n\r\n" % (av_hits, field[0], field[1], field[2], field[3], field[4], field[5], field[6], field[7], field[8], field[9], field[10], field[11], field[12], field[13], field[14], field[15], field[16], tc_hits,)
                         susp_output.append(outputtext)
                         suspentry_count = suspentry_count + 1
                    elif nonunicodedetected == "yes":
                         print('%s' % scan_with_no_results)
                         badunicode="This Registry entry under the path %s appears to contain abnormal characters" % (field[1])
                         outputtext = "%s\r\n%s\r\nTime: %s\r\nEntry Location: %s\r\nEntry: %s\r\nEnabled: %s\r\nCategory: %s\r\nProfile: %s\r\nDescrption: %s\r\nPublisher: %s\r\nFilePath: %s\r\nVersion: %s\r\nLaunchString: %s\r\nMD5: %s\r\nSHA1: %s\r\nPESHA1: %s\r\nPESHA256: %s\r\nSHA256: %s\r\nIMPHASH: %s\r\nThreatCrowd Results: %s\r\n\r\n\r\n" % (badunicode, av_hits, field[0], field[1], field[2], field[3], field[4], field[5], field[6], field[7], field[8], field[9], field[10], field[11], field[12], field[13], field[14], field[15], field[16], tc_hits,)
                         susp_output.append(outputtext)
                         suspentry_count = suspentry_count + 1
                elif nonunicodedetected == "yes":
                    badunicode="This Registry entry under the path %s appears to contain abnormal characters" % (field[1])
                    outputtext = "%s\r\nTime: %s\r\nEntry Location: %s\r\nEntry: %s\r\nEnabled: %s\r\nCategory: %s\r\nProfile: %s\r\nDescrption: %s\r\nPublisher: %s\r\nFilePath: %s\r\nVersion: %s\r\nLaunchString: %s\r\nMD5: %s\r\nSHA1: %s\r\nPESHA1: %s\r\nPESHA256: %s\r\nSHA256: %s\r\nIMPHASH: %s\r\nThreatCrowd Results: %s\r\n\r\n\r\n" % (badunicode, field[0], field[1], field[2], field[3], field[4], field[5], field[6], field[7], field[8], field[9], field[10], field[11], field[12], field[13], field[14], field[15], field[16], tc_hits,)
                    susp_output.append(outputtext)
                    suspentry_count = suspentry_count + 1
            elif nonunicodedetected == "yes" and len(field[15]) == 64 and autorunsversion == "priortothirteenpointfive":
                sha256 = field[15]
                md5 = field[11]		
                if has_virustotal and has_internet:
                    av_hits = virustotal_query_hash(sha256)
                    tc_hits = threatcrowd_query_hash(md5)
                    if "This file was detected by" in av_hits and nonunicodedetected == "yes":
                         badunicode="This Registry entry under the path %s appears to contain abnormal characters" % (field[1])
                         outputtext = "%s\r\n%s\r\nTime: %s\r\nEntry Location: %s\r\nEntry: %s\r\nEnabled: %s\r\nCategory: %s\r\nProfile: %s\r\nDescrption: %s\r\nPublisher: %s\r\nFilePath: %s\r\nVersion: %s\r\nLaunchString: %s\r\nMD5: %s\r\nSHA1: %s\r\nPESHA1: %s\r\nPESHA256: %s\r\nSHA256: %s\r\nIMPHASH: %s\r\nThreatCrowd Results: %s\r\n\r\n\r\n" % (badunicode, av_hits, field[0], field[1], field[2], field[3], field[4], field[5], field[6], field[7], field[8], field[9], field[10], field[11], field[12], field[13], field[14], field[15], field[16], tc_hits,)
                         susp_output.append(outputtext)
                         suspentry_count = suspentry_count + 1
                    elif nonunicodedetected == "yes":
                         print('%s' % scan_with_no_results)
                         badunicode="This Registry entry under the path %s appears to contain abnormal characters" % (field[1])
                         outputtext = "%s\r\n%s\r\nTime: %s\r\nEntry Location: %s\r\nEntry: %s\r\nEnabled: %s\r\nCategory: %s\r\nProfile: %s\r\nDescrption: %s\r\nPublisher: %s\r\nFilePath: %s\r\nVersion: %s\r\nLaunchString: %s\r\nMD5: %s\r\nSHA1: %s\r\nPESHA1: %s\r\nPESHA256: %s\r\nSHA256: %s\r\nIMPHASH: %s\r\nThreatCrowd Results: %s\r\n\r\n\r\n" % (badunicode, av_hits, field[0], field[1], field[2], field[3], field[4], field[5], field[6], field[7], field[8], field[9], field[10], field[11], field[12], field[13], field[14], field[15], field[16], tc_hits,)
                         susp_output.append(outputtext)
                         suspentry_count = suspentry_count + 1
            elif nonunicodedetected == "yes" and autorunsversion == "priortothirteenpointfive":
                badunicode="This Registry entry under the path %s appears to contain abnormal characters" % (field[1])
                outputtext = "%s\r\nTime: %s\r\nEntry Location: %s\r\nEntry: %s\r\nEnabled: %s\r\nCategory: %s\r\nProfile: %s\r\nDescrption: %s\r\nPublisher: %s\r\nFilePath: %s\r\nVersion: %s\r\nLaunchString: %s\r\nMD5: %s\r\nSHA1: %s\r\nPESHA1: %s\r\nPESHA256: %s\r\nSHA256: %s\r\nIMPHASH: %s\r\nThreatCrowd Results: %s\r\n\r\n\r\n" % (badunicode, field[0], field[1], field[2], field[3], field[4], field[5], field[6], field[7], field[8], field[9], field[10], field[11], field[12], field[13], field[14], field[15], field[16], tc_hits,)
                susp_output.append(outputtext)
                suspentry_count = suspentry_count + 1
            elif "rundll32.exe javascript" in uncline and "File not found:" in field[8]:
                poweliks="This Registry entry under the path %s appears to be similar to poweliks" % (field[1])
                print ("[!] The Registry entry under the path %s appears to be similar to poweliks" % (field[1]))
                outputtext = "%s\r\nTime: %s\r\nEntry Location: %s\r\nEntry: %s\r\nEnabled: %s\r\nCategory: %s\r\nProfile: %s\r\nDescrption: %s\r\nPublisher: %s\r\nFilePath: %s\r\nVersion: %s\r\nLaunchString: %s\r\nMD5: %s\r\nSHA1: %s\r\nPESHA1: %s\r\nPESHA256: %s\r\nSHA256: %s\r\nIMPHASH: %s\r\nThreatCrowd Results: %s\r\n\r\n\r\n" % (poweliks, field[0], field[1], field[2], field[3], field[4], field[5], field[6], field[7], field[8], field[9], field[10], field[11], field[12], field[13], field[14], field[15], field[16], tc_hits,)
                susp_output.append(outputtext)
                suspentry_count = suspentry_count + 1
            elif "RunHTMLApplication" in uncline and "File not found:" in field[8]:
                poweliks="This Registry entry under the path %s appears to be similar to poweliks" % (field[1])
                print ("[!] The Registry entry under the path %s appears to be similar to poweliks" % (field[1]))
                outputtext = "%s\r\nTime: %s\r\nEntry Location: %s\r\nEntry: %s\r\nEnabled: %s\r\nCategory: %s\r\nProfile: %s\r\nDescrption: %s\r\nPublisher: %s\r\nFilePath: %s\r\nVersion: %s\r\nLaunchString: %s\r\nMD5: %s\r\nSHA1: %s\r\nPESHA1: %s\r\nPESHA256: %s\r\nSHA256: %s\r\nIMPHASH: %s\r\nThreatCrowd Results: %s\r\n\r\n\r\n" % (poweliks, field[0], field[1], field[2], field[3], field[4], field[5], field[6], field[7], field[8], field[9], field[10], field[11], field[12], field[13], field[14], field[15], field[16], tc_hits,)
                susp_output.append(outputtext)
                suspentry_count = suspentry_count + 1
            elif "mshta.exe" in uncline and "javascript:" in uncline and "File not found:" in field[8]:
                poweliks="This Registry entry under the path %s appears to be similar to kovter" % (field[1])
                print ("[!] The Registry entry under the path %s appears to be similar to kovter" % (field[1]))
                outputtext = "%s\r\nTime: %s\r\nEntry Location: %s\r\nEntry: %s\r\nEnabled: %s\r\nCategory: %s\r\nProfile: %s\r\nDescrption: %s\r\nPublisher: %s\r\nFilePath: %s\r\nVersion: %s\r\nLaunchString: %s\r\nMD5: %s\r\nSHA1: %s\r\nPESHA1: %s\r\nPESHA256: %s\r\nSHA256: %s\r\nIMPHASH: %s\r\nThreatCrowd Results: %s\r\n\r\n\r\n" % (poweliks, field[0], field[1], field[2], field[3], field[4], field[5], field[6], field[7], field[8], field[9], field[10], field[11], field[12], field[13], field[14], field[15], field[16], tc_hits,)
                susp_output.append(outputtext)
                suspentry_count = suspentry_count + 1
            elif "mshta.exe" in uncline and "javascript:" in uncline and "ActiveXObject" in uncline:
                poweliks="This Registry entry under the path %s appears to be similar to kovter" % (field[1])
                print ("[!] The Registry entry under the path %s appears to be similar to kovter" % (field[1]))
                outputtext = "%s\r\nTime: %s\r\nEntry Location: %s\r\nEntry: %s\r\nEnabled: %s\r\nCategory: %s\r\nProfile: %s\r\nDescrption: %s\r\nPublisher: %s\r\nFilePath: %s\r\nVersion: %s\r\nLaunchString: %s\r\nMD5: %s\r\nSHA1: %s\r\nPESHA1: %s\r\nPESHA256: %s\r\nSHA256: %s\r\nIMPHASH: %s\r\nThreatCrowd Results: %s\r\n\r\n\r\n" % (poweliks, field[0], field[1], field[2], field[3], field[4], field[5], field[6], field[7], field[8], field[9], field[10], field[11], field[12], field[13], field[14], field[15], field[16], tc_hits,)
                susp_output.append(outputtext)
                suspentry_count = suspentry_count + 1
            elif "Verified" in field[7] and verified_count == 0 and process_all_hashes == "no":
                print('[!] Verified digital signature detected. Moving along')
                verified_count = verified_count +1
            elif "Verified" in field[7] and process_all_hashes == "no":
                verified_count = verified_count +1	

#This is where the autoruns 13.5 (and later) data gets processed

            elif process_all_hashes == "yes" and len(field[16]) == 64 and autorunsversion == "thirteenpointfive":
                sha256 = field[16]
                md5 = field[12]	
                if has_virustotal and has_internet:
                    av_hits = virustotal_query_hash(sha256)
                    tc_hits = threatcrowd_query_hash(md5)
                    if "This file was detected by" in av_hits and nonunicodedetected == "yes":
                         badunicode="This Registry entry under the path %s appears to contain abnormal characters" % (field[1])
                         outputtext = "%s\r\n%s\r\nTime: %s\r\nEntry Location: %s\r\nEntry: %s\r\nEnabled: %s\r\nCategory: %s\r\nProfile: %s\r\nDescrption: %s\r\nSigner: %s\r\nCompany: %s\r\nFilePath: %s\r\nVersion: %s\r\nLaunchString: %s\r\nMD5: %s\r\nSHA1: %s\r\nPESHA1: %s\r\nPESHA256: %s\r\nSHA256: %s\r\nIMPHASH: %s\r\nThreatCrowd Results: %s\r\n\r\n\r\n" % (badunicode, av_hits, field[0], field[1], field[2], field[3], field[4], field[5], field[6], field[7], field[8], field[9], field[10], field[11], field[12], field[13], field[14], field[15], field[16], field[17], tc_hits,)
                         susp_output.append(outputtext)
                         suspentry_count = suspentry_count + 1
                    elif "This file was detected by" in av_hits and nonunicodedetected == "no":
                         outputtext = "%s\r\nTime: %s\r\nEntry Location: %s\r\nEntry: %s\r\nEnabled: %s\r\nCategory: %s\r\nProfile: %s\r\nDescrption: %s\r\nSigner: %s\r\nCompany: %s\r\nFilePath: %s\r\nVersion: %s\r\nLaunchString: %s\r\nMD5: %s\r\nSHA1: %s\r\nPESHA1: %s\r\nPESHA256: %s\r\nSHA256: %s\r\nIMPHASH: %s\r\nThreatCrowd Results: %s\r\n\r\n\r\n" % (av_hits, field[0], field[1], field[2], field[3], field[4], field[5], field[6], field[7], field[8], field[9], field[10], field[11], field[12], field[13], field[14], field[15], field[16], field[17], tc_hits,)
                         susp_output.append(outputtext)
                         suspentry_count = suspentry_count + 1
                    elif nonunicodedetected == "yes":
                         print('%s' % scan_with_no_results)
                         badunicode="This Registry entry under the path %s appears to contain abnormal characters" % (field[1])
                         outputtext = "%s\r\n%s\r\nTime: %s\r\nEntry Location: %s\r\nEntry: %s\r\nEnabled: %s\r\nCategory: %s\r\nProfile: %s\r\nDescrption: %s\r\nSigner: %s\r\nCompany: %s\r\nFilePath: %s\r\nVersion: %s\r\nLaunchString: %s\r\nMD5: %s\r\nSHA1: %s\r\nPESHA1: %s\r\nPESHA256: %s\r\nSHA256: %s\r\nIMPHASH: %s\r\nThreatCrowd Results: %s\r\n\r\n\r\n" % (badunicode, av_hits, field[0], field[1], field[2], field[3], field[4], field[5], field[6], field[7], field[8], field[9], field[10], field[11], field[12], field[13], field[14], field[15], field[16], field[17], tc_hits,)
                         susp_output.append(outputtext)
                         suspentry_count = suspentry_count + 1
                    elif "WAS NOT detected by" in av_hits:
                         print('%s' % scan_with_no_results)
                         outputtext = "%s\r\n\r\n\r\n" % (av_hits)
                         susp_output.append(outputtext)
                elif nonunicodedetected == "yes":
                    badunicode="This Registry entry under the path %s appears to contain abnormal characters" % (field[1])
                    outputtext = "%s\r\nTime: %s\r\nEntry Location: %s\r\nEntry: %s\r\nEnabled: %s\r\nCategory: %s\r\nProfile: %s\r\nDescrption: %s\r\nSigner: %s\r\nCompany: %s\r\nFilePath: %s\r\nVersion: %s\r\nLaunchString: %s\r\nMD5: %s\r\nSHA1: %s\r\nPESHA1: %s\r\nPESHA256: %s\r\nSHA256: %s\r\nIMPHASH: %s\r\nThreatCrowd Results: %s\r\n\r\n\r\n" % (badunicode, field[0], field[1], field[2], field[3], field[4], field[5], field[6], field[7], field[8], field[9], field[10], field[11], field[12], field[13], field[14], field[15], field[16], field[17], tc_hits,)
                    susp_output.append(outputtext)
                    suspentry_count = suspentry_count + 1
            elif "Verified" not in field[7] and len(field[16]) == 64 and autorunsversion == "thirteenpointfive":
                sha256 = field[16]
                md5 = field[12]
                if has_virustotal and has_internet:
                    av_hits = virustotal_query_hash(sha256)
                    tc_hits = threatcrowd_query_hash(md5)
                    if "This file was detected by" in av_hits and nonunicodedetected == "yes":
                         badunicode="This Registry entry under the path %s appears to contain abnormal characters" % (field[1])
                         outputtext = "%s\r\n%s\r\nTime: %s\r\nEntry Location: %s\r\nEntry: %s\r\nEnabled: %s\r\nCategory: %s\r\nProfile: %s\r\nDescrption: %s\r\nSigner: %s\r\nCompany: %s\r\nFilePath: %s\r\nVersion: %s\r\nLaunchString: %s\r\nMD5: %s\r\nSHA1: %s\r\nPESHA1: %s\r\nPESHA256: %s\r\nSHA256: %s\r\nIMPHASH: %s\r\nThreatCrowd Results: %s\r\n\r\n\r\n" % (badunicode, av_hits, field[0], field[1], field[2], field[3], field[4], field[5], field[6], field[7], field[8], field[9], field[10], field[11], field[12], field[13], field[14], field[15], field[16], field[17], tc_hits,)
                         susp_output.append(outputtext)
                         suspentry_count = suspentry_count + 1
                    elif "This file was detected by" in av_hits and nonunicodedetected == "no":
                         outputtext = "%s\r\nTime: %s\r\nEntry Location: %s\r\nEntry: %s\r\nEnabled: %s\r\nCategory: %s\r\nProfile: %s\r\nDescrption: %s\r\nSigner: %s\r\nCompany: %s\r\nFilePath: %s\r\nVersion: %s\r\nLaunchString: %s\r\nMD5: %s\r\nSHA1: %s\r\nPESHA1: %s\r\nPESHA256: %s\r\nSHA256: %s\r\nIMPHASH: %s\r\nThreatCrowd Results: %s\r\n\r\n\r\n" % (av_hits, field[0], field[1], field[2], field[3], field[4], field[5], field[6], field[7], field[8], field[9], field[10], field[11], field[12], field[13], field[14], field[15], field[16], field[17], tc_hits,)
                         susp_output.append(outputtext)
                         suspentry_count = suspentry_count + 1
                    elif nonunicodedetected == "yes":
                         print('%s' % scan_with_no_results)
                         badunicode="This Registry entry under the path %s appears to contain abnormal characters" % (field[1])
                         outputtext = "%s\r\n%s\r\nTime: %s\r\nEntry Location: %s\r\nEntry: %s\r\nEnabled: %s\r\nCategory: %s\r\nProfile: %s\r\nDescrption: %s\r\nSigner: %s\r\nCompany: %s\r\nFilePath: %s\r\nVersion: %s\r\nLaunchString: %s\r\nMD5: %s\r\nSHA1: %s\r\nPESHA1: %s\r\nPESHA256: %s\r\nSHA256: %s\r\nIMPHASH: %s\r\nThreatCrowd Results: %s\r\n\r\n\r\n" % (badunicode, av_hits, field[0], field[1], field[2], field[3], field[4], field[5], field[6], field[7], field[8], field[9], field[10], field[11], field[12], field[13], field[14], field[15], field[16], field[17], tc_hits,)
                         susp_output.append(outputtext)
                         suspentry_count = suspentry_count + 1
                elif nonunicodedetected == "yes":
                    badunicode="This Registry entry under the path %s appears to contain abnormal characters" % (field[1])
                    outputtext = "%s\r\nTime: %s\r\nEntry Location: %s\r\nEntry: %s\r\nEnabled: %s\r\nCategory: %s\r\nProfile: %s\r\nDescrption: %s\r\nSigner: %s\r\nCompany: %s\r\nFilePath: %s\r\nVersion: %s\r\nLaunchString: %s\r\nMD5: %s\r\nSHA1: %s\r\nPESHA1: %s\r\nPESHA256: %s\r\nSHA256: %s\r\nIMPHASH: %s\r\nThreatCrowd Results: %s\r\n\r\n\r\n" % (badunicode, field[0], field[1], field[2], field[3], field[4], field[5], field[6], field[7], field[8], field[9], field[10], field[11], field[12], field[13], field[14], field[15], field[16], field[17], tc_hits,)
                    susp_output.append(outputtext)
                    suspentry_count = suspentry_count + 1
            elif nonunicodedetected == "yes" and len(field[16]) == 64 and autorunsversion == "thirteenpointfive":
                sha256 = field[16]
                md5 = field[12]
                if has_virustotal and has_internet:
                    av_hits = virustotal_query_hash(sha256)
                    tc_hits = threatcrowd_query_hash(md5)
                    if "This file was detected by" in av_hits and nonunicodedetected == "yes":
                         badunicode="This Registry entry under the path %s appears to contain abnormal characters" % (field[1])
                         outputtext = "%s\r\n%s\r\nTime: %s\r\nEntry Location: %s\r\nEntry: %s\r\nEnabled: %s\r\nCategory: %s\r\nProfile: %s\r\nDescrption: %s\r\nSigner: %s\r\nCompany: %s\r\nFilePath: %s\r\nVersion: %s\r\nLaunchString: %s\r\nMD5: %s\r\nSHA1: %s\r\nPESHA1: %s\r\nPESHA256: %s\r\nSHA256: %s\r\nIMPHASH: %s\r\nThreatCrowd Results: %s\r\n\r\n\r\n" % (badunicode, av_hits, field[0], field[1], field[2], field[3], field[4], field[5], field[6], field[7], field[8], field[9], field[10], field[11], field[12], field[13], field[14], field[15], field[16], field[17], tc_hits,)
                         susp_output.append(outputtext)
                         suspentry_count = suspentry_count + 1
                    elif nonunicodedetected == "yes":
                         print('%s' % scan_with_no_results)
                         badunicode="This Registry entry under the path %s appears to contain abnormal characters" % (field[1])
                         outputtext = "%s\r\n%s\r\nTime: %s\r\nEntry Location: %s\r\nEntry: %s\r\nEnabled: %s\r\nCategory: %s\r\nProfile: %s\r\nDescrption: %s\r\nSigner: %s\r\nCompany: %s\r\nFilePath: %s\r\nVersion: %s\r\nLaunchString: %s\r\nMD5: %s\r\nSHA1: %s\r\nPESHA1: %s\r\nPESHA256: %s\r\nSHA256: %s\r\nIMPHASH: %s\r\nThreatCrowd Results: %s\r\n\r\n\r\n" % (badunicode, av_hits, field[0], field[1], field[2], field[3], field[4], field[5], field[6], field[7], field[8], field[9], field[10], field[11], field[12], field[13], field[14], field[15], field[16], field[17], tc_hits,)
                         susp_output.append(outputtext)
                         suspentry_count = suspentry_count + 1
            elif nonunicodedetected == "yes" and autorunsversion == "thirteenpointfive":
                badunicode="This Registry entry under the path %s appears to contain abnormal characters" % (field[1])
                outputtext = "%s\r\nTime: %s\r\nEntry Location: %s\r\nEntry: %s\r\nEnabled: %s\r\nCategory: %s\r\nProfile: %s\r\nDescrption: %s\r\nSigner: %s\r\nCompany: %s\r\nFilePath: %s\r\nVersion: %s\r\nLaunchString: %s\r\nMD5: %s\r\nSHA1: %s\r\nPESHA1: %s\r\nPESHA256: %s\r\nSHA256: %s\r\nIMPHASH: %s\r\nThreatCrowd Results: %s\r\n\r\n\r\n" % (badunicode, field[0], field[1], field[2], field[3], field[4], field[5], field[6], field[7], field[8], field[9], field[10], field[11], field[12], field[13], field[14], field[15], field[16], field[17], tc_hits,)
                susp_output.append(outputtext)
                suspentry_count = suspentry_count + 1
            elif "rundll32.exe javascript" in uncline and "File not found:" in field[9]:
                poweliks="This Registry entry under the path %s appears to be similar to poweliks" % (field[1])
                print ("[!] The Registry entry under the path %s appears to be similar to poweliks" % (field[1]))
                outputtext = "%s\r\nTime: %s\r\nEntry Location: %s\r\nEntry: %s\r\nEnabled: %s\r\nCategory: %s\r\nProfile: %s\r\nDescrption: %s\r\nSigner: %s\r\nCompany: %s\r\nFilePath: %s\r\nVersion: %s\r\nLaunchString: %s\r\nMD5: %s\r\nSHA1: %s\r\nPESHA1: %s\r\nPESHA256: %s\r\nSHA256: %s\r\nIMPHASH: %s\r\nThreatCrowd Results: %s\r\n\r\n\r\n" % (poweliks, field[0], field[1], field[2], field[3], field[4], field[5], field[6], field[7], field[8], field[9], field[10], field[11], field[12], field[13], field[14], field[15], field[16], field[17], tc_hits,)
                susp_output.append(outputtext)
                suspentry_count = suspentry_count + 1
            elif "RunHTMLApplication" in uncline and "File not found:" in field[9]:
                poweliks="This Registry entry under the path %s appears to be similar to poweliks" % (field[1])
                print ("[!] The Registry entry under the path %s appears to be similar to poweliks" % (field[1]))
                outputtext = "%s\r\nTime: %s\r\nEntry Location: %s\r\nEntry: %s\r\nEnabled: %s\r\nCategory: %s\r\nProfile: %s\r\nDescrption: %s\r\nSigner: %s\r\nCompany: %s\r\nFilePath: %s\r\nVersion: %s\r\nLaunchString: %s\r\nMD5: %s\r\nSHA1: %s\r\nPESHA1: %s\r\nPESHA256: %s\r\nSHA256: %s\r\nIMPHASH: %s\r\nThreatCrowd Results: %s\r\n\r\n\r\n" % (poweliks, field[0], field[1], field[2], field[3], field[4], field[5], field[6], field[7], field[8], field[9], field[10], field[11], field[12], field[13], field[14], field[15], field[16], field[17], tc_hits,)
                susp_output.append(outputtext)
                suspentry_count = suspentry_count + 1
            elif "mshta.exe" in uncline and "javascript:" in uncline and "File not found:" in field[9]:
                poweliks="This Registry entry under the path %s appears to be similar to kovter" % (field[1])
                print ("[!] The Registry entry under the path %s appears to be similar to kovter" % (field[1]))
                outputtext = "%s\r\nTime: %s\r\nEntry Location: %s\r\nEntry: %s\r\nEnabled: %s\r\nCategory: %s\r\nProfile: %s\r\nDescrption: %s\r\nSigner: %s\r\nCompany: %s\r\nFilePath: %s\r\nVersion: %s\r\nLaunchString: %s\r\nMD5: %s\r\nSHA1: %s\r\nPESHA1: %s\r\nPESHA256: %s\r\nSHA256: %s\r\nIMPHASH: %s\r\nThreatCrowd Results: %s\r\n\r\n\r\n" % (poweliks, field[0], field[1], field[2], field[3], field[4], field[5], field[6], field[7], field[8], field[9], field[10], field[11], field[12], field[13], field[14], field[15], field[16], field[17], tc_hits,)
                susp_output.append(outputtext)
                suspentry_count = suspentry_count + 1
            elif "mshta.exe" in uncline and "javascript:" in uncline and "ActiveXObject" in uncline:
                poweliks="This Registry entry under the path %s appears to be similar to kovter" % (field[1])
                print ("[!] The Registry entry under the path %s appears to be similar to kovter" % (field[1]))
                outputtext = "%s\r\nTime: %s\r\nEntry Location: %s\r\nEntry: %s\r\nEnabled: %s\r\nCategory: %s\r\nProfile: %s\r\nDescrption: %s\r\nSigner: %s\r\nCompany: %s\r\nFilePath: %s\r\nVersion: %s\r\nLaunchString: %s\r\nMD5: %s\r\nSHA1: %s\r\nPESHA1: %s\r\nPESHA256: %s\r\nSHA256: %s\r\nIMPHASH: %s\r\nThreatCrowd Results: %s\r\n\r\n\r\n" % (poweliks, field[0], field[1], field[2], field[3], field[4], field[5], field[6], field[7], field[8], field[9], field[10], field[11], field[12], field[13], field[14], field[15], field[16], field[17], tc_hits,)
                susp_output.append(outputtext)
                suspentry_count = suspentry_count + 1
            elif "Verified" in field[7] and verified_count == 0 and process_all_hashes == "no":
                print('[!] Verified digital signature detected. Moving along')
                verified_count = verified_count +1
            elif "Verified" in field[7] and process_all_hashes == "no":
                verified_count = verified_count +1	
 
        except IndexError:
            if debug:
                sys.stderr.write(line)
                sys.stderr.write(format_exc())
            error_output.append(original_line.strip())

    time_parse_csv_end = time.time()
    
    report.append('-=] Autorun Analysis Report generated by buatapa v%s' % __VERSION__)
    report.append('-=] Developed by %s' % __AUTHOR__ + ' %s' % __EMAIL__)
    report.append('')
    global time_analyze
    time_analyze = time_parse_csv_end - time_parse_csv_start
    report.append('-=] The script took %02d:%02d:%02d to complete' % (int (time_analyze/3600), int ( (time_analyze % 3600) / 60), int (time_analyze % 60) ))
    report.append('')

    report.append('')
    report.append('Possible autoruns of interest:')
    report.append('==================')
    for event in susp_output:
        report.append(event)

    if error_output:
        report.append('\r\n\r\n\r\n\r\n\r\n\r\nERRORS DETECTED')
        report.append('The following items could not be parsed correctly:')
        for error in error_output:
            report.append(error)
# End of parse_csv()


def main():
    """
    Main routine, parses arguments and calls other routines

    Arguments:
        None
    Results:
        None
    """
    global generalize_paths
    global timeout_seconds

    print('--===[   buatapa v%s ]===--' % __VERSION__)
    print('--===[   @brianjmoran   ]===--\r\n')

    parser = ArgumentParser()
    parser.add_argument('-c', '--csv', help='Analyze Autoruns CSV file', required=False)
    parser.add_argument('--unicode', help='Displays all entries with non-ASCII characters (off by default)', required=False, action="store_true")
    parser.add_argument('--full', help='Processes all files in autoruns (off by default)', required=False, action="store_true")
    parser.add_argument('--info', help='Prints script information', required=False,  action="store_true")
    args = parser.parse_args()
    report = list()

    # Check if user-specified autoruns.csv file

    if args.info:
        print ('\n\nScript Information: buatapa.py\n------------------------------')
        print ('Version: %s' % __VERSION__ )
        print ('Author: %s' % __AUTHOR__ )
        print ('Email: %s' % __EMAIL__ )
        print ('%s' % __ENDOFLINE__ )
        sys.exit(1)
    if args.csv:
        if args.unicode:
            global find_unicode
            find_unicode="yes"
        if args.full:
            global process_all_hashes
            process_all_hashes="yes"
        if file_exists(args.csv):
            timestamp=time.time()
            formattedts = datetime.fromtimestamp(timestamp).strftime('%Y%m%d_%H%M%S')
            txt_file = formattedts + '_buatapa_output.txt'
            parse_csv(args.csv, report)
            global num_lines
            num_lines = num_lines +1
            print('\r\n\r\n-----------------------------\r\nbuatapa processing statistics\r\n-----------------------------')
            print('The file originally had %s autorun entries' % num_lines )
            print('The script queried a total of %s entries in VirusTotal' % vtquery_count)
            print('Out of %s total entries, the script identified %s possible malicious autorun entries' % (num_lines, suspentry_count))
            if verified_count != 0:
                 print('\n*****NOTE*****\nThe script identified %s entries with verified digital signatures.\nTo process these, please run the script again with the --full option.' % verified_count)
            print ('\r\nThe script took %02d:%02d:%02d to complete\r\n' % (int (time_analyze/3600), int ( (time_analyze % 3600) / 60), int (time_analyze % 60) ))
            if suspentry_count == 0:
				print ('[!] Not saving output to file as running buatapa yielded no results\n')
				sys.exit(1)
            else:
                print('[*] Saving report to: %s' % txt_file)
                codecs.open(txt_file, 'w', 'utf-8').write('\r\n'.join(report))
                open_file_with_assoc(txt_file)
                sys.exit(1)
        else:
            print('Cannot open the file\n\n')
            parser.print_usage()
            print('Please specify an autoruns.csv file for buatapa to parse\n\n----- End of Line -----\n\n')
            sys.exit(1)
    else:
	    parser.print_usage()
	    print('\nERROR!\nPlease specify an autoruns.csv file for buatapa to parse\n\n----- End of Line -----\n\n')
	    sys.exit(1)
    # End of main()

if __name__ == '__main__':
    main()
