#!/bin/bash

# Last updated 16 October 2014 by Brian Moran (brian@brimorlabs.com)
# Please read "ReadMe.txt" for more information regarding GPL, the script itself, and changes
# RELEASE DATE: 20141016
# AUTHOR: Brian Moran (brian@brimorlabs.com)
# TWITTER: BriMor Labs (@BriMorLabs)
# Version: 1.4
# Copyright: 2013-2014, Brian Moran

# This file is part of the Live Response Collection
# The Live Response Collection is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
# This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
# You should have received a copy of the GNU General Public License along with this program.  If not, see <http://www.gnu.org/licenses/>.
# Additionally, usages of all tools fall under the express license agreement stated by the tool itself.

cname=$(hostname -s)
ts=$(date +%Y%m%d%H%M%S)
computername=$cname\_$ts
mkdir -p $computername
mkdir -p $computername/ForensicImages/Memory
mkdir -p $computername/ForensicImages/DiskImage
mkdir -p $computername/LiveResponseData/BasicInfo
mkdir -p $computername/LiveResponseData/UserInfo
mkdir -p $computername/LiveResponseData/NetworkInfo
mkdir -p $computername/LiveResponseData/PersistenceMechanisms
mkdir -p $computername/LiveResponseData/Logs
mkdir -p $computername/LiveResponseData/Logs/var
mkdir -p $computername/LiveResponseData/Logs/private/var
# mkdir -p $computername/HiddenFiles


#HIDDEN FILES


#LOGS
cp /var/log/*.log* $computername/LiveResponseData/Logs/var
cp /private/var/log/*.log* $computername/LiveResponseData/Logs/private/var

#BASIC INFORMATION

date >> $computername/LiveResponseData/BasicInfo/date.txt
echo "date"
hostname >> $computername/LiveResponseData/BasicInfo/hostname.txt
echo "hostname"
who >> $computername/LiveResponseData/BasicInfo/Logged_In_Users.txt
echo "who"
ps auxwww >> $computername/LiveResponseData/BasicInfo/List_of_Running_Processes.txt
echo "ps auxwww"
mount >> $computername/LiveResponseData/BasicInfo/Mounted_items.txt
echo "mount"
diskutil list >> $computername/LiveResponseData/BasicInfo/Disk_utility.txt
echo "diskutil"
kextstat -l >> $computername/LiveResponseData/BasicInfo/Loaded_Kernel_Extensions.txt
echo “kextstat -l”



#USER INFORMATION

cat /etc/passwd >> $computername/LiveResponseData/UserInfo/passwd.txt
echo "cat /etc/passwd"
cat /etc/group >> $computername/LiveResponseData/UserInfo/group.txt
echo "cat /etc/group"
for i in `ls /Users/`
do 
	cat /Users/$i/.bash_history >> $computername/LiveResponseData/UserInfo/User-$i-bash_History.txt
	echo "cat $i bash_history"
	cat /Users/$i/.sh_history >> $computername/LiveResponseData/UserInfo/User-$i-sh_History.txt
	echo "cat $i sh_history"
	ls -al /Users/$i/Library/LaunchAgents/ | grep -v ^d >> $computername/LiveResponseData/PersistenceMechanisms/User-$i-LaunchAgents.txt
	echo "cat $i Launch Agents"
	plutil -convert xml1 /Users/$i/Library/Preferences/loginwindow.plist -o $computername/LiveResponseData/PersistenceMechanisms/User-$i-loginwindow_plist.txt
	echo "plutil -convert xml1 $i loginwindow.plist"
	plutil -convert xml1 /Users/$i/Library/Preferences/AddressBookMe.plist -o $computername/LiveResponseData/UserInfo/User-$i-AddressBookMe_plist.txt
	echo “pltuil -convert xml1 $i AddressBookMe.plist”
	plutil -convert xml1 /Users/$i/Library/Prefernces/com.apple.loginitems.plist -o $computername/LiveResponseData/PersistenceMechanisms/User-$i-LaunchedLogInItems_plist.txt
	echo “plutil -convert xml1 $i LaunchedLogInItems.plist”

done

#PERSISTENCE MECHANISMS

ls -laR /System/Library/StartupItems | grep -v ^d >> $computername/LiveResponseData/PersistenceMechanisms/System_Startup_Items.txt
echo "ls -laR /System/Library/StartupItems"
ls -laR /Library/StartupItems | grep -v ^d >> $computername/LiveResponseData/PersistenceMechanisms/Library_Startup_Items.txt
echo "ls -laR /Library/StartupItems"
ls -al /System/Library/LaunchAgents | grep -v ^d >> $computername/LiveResponseData/PersistenceMechanisms/System_Launch_Agents.txt
echo "ls -al /System/Library/LaunchAgents"
ls -al /System/Library/LaunchDaemons | grep -v ^d >> $computername/LiveResponseData/PersistenceMechanisms/System_Launch_Daemons.txt
echo "ls -al /System/Library/LaunchDaemons"
ls -al /Library/LaunchAgents | grep -v ^d >> $computername/LiveResponseData/PersistenceMechanisms/Library_Launch_Agents.txt
echo "ls -al /Library/LaunchAgents"
ls -al /Library/LaunchDaemons | grep -v ^d >> $computername/LiveResponseData/PersistenceMechanisms/Library_Launch_Daemons.txt
echo "ls -al /Library/LaunchDaemons"
find /Applications/ -name LogInItems -exec ls -lsct {} \; >> $computername/LiveResponseData/PersistenceMechanisms/Applications_LogInItems.txt
echo “find /Applications/ -name LogInItems -exec ls -lsct {} \;”



#NETWORK INFO

netstat -an >> $computername/LiveResponseData/NetworkInfo/netstat_current_connections.txt
echo "netstat"
lsof -i >> $computername/LiveResponseData/NetworkInfo/lsof_network_connections.txt
echo "lsof -i"
scutil --dns >> $computername/LiveResponseData/NetworkInfo/DNS_Configuration.txt
echo "scutil --dns"
netstat -rn >> $computername/LiveResponseData/NetworkInfo/Routing_table.txt
echo "netstat -rn"
arp -an >> $computername/LiveResponseData/NetworkInfo/ARP_table.txt
echo "arp -an"
ifconfig -a >> $computername/LiveResponseData/NetworkInfo/Network_interface_info.txt
echo "ifconfig -a"
ifconfig -L >> $computername/LiveResponseData/NetworkInfo/Network_interface_info.txt
echo "ifconfig -L"
cat /etc/hosts.allow >> $computername/LiveResponseData/NetworkInfo/Hosts_allow.txt
echo "cat /etc/hosts.allow"
defaults read /Library/Preferences/SystemConfiguration/com.apple.airport.preferences.plist |sed 's|\./|`pwd`/|g' | sed 's|.plist||g'|grep 'LastConnected' -A 9 >> $computername/LiveResponseData/NetworkInfo/Wifi_Access_Points.txt
echo “Parsing com.apple.airport.preferences.plist”
plutil -convert xml1 /Library/Preferences/com.apple.alf.plist -o $computername/LiveResponseData/NetworkInfo/FirewallConfiguration_plist.txt
echo “Parsing com.apple.alf.plist”
plutil -convert xml1 /Library/Preferences/SystemConfiguration/com.apple.nat.plist -o $computername/LiveResponseData/NetworkInfo/NATConfiguration_plist.txt
echo “Parsing com.apple.nat.plist”
plutil -convert xml1 /Library/Preferences/SystemConfiguration/com.apple.smb.server.plist -o $computername/LiveResponseData/NetworkInfo/SMBConfiguration_plist.txt
echo “Parsing com.apple.smb.server.plist”

#PROCESSING DETAILS AND HASHES
echo OS Type: OSX >> $computername/Processing_Details_and_Hashes.txt
echo Computername: $cname >> $computername/Processing_Details_and_Hashes.txt
echo Time stamp: $ts >> $computername/Processing_Details_and_Hashes.txt
echo >> $computername/Processing_Details_and_Hashes.txt
echo ==========MD5 HASHES========== >> $computername/Processing_Details_and_Hashes.txt
find $computername -type f \( ! -name Processing_Details_and_Hashes.txt \) -exec md5 {} \; >> $computername/Processing_Details_and_Hashes.txt
echo >> $computername/Processing_Details_and_Hashes.txt
echo ==========SHA256 HASHES========== >> $computername/Processing_Details_and_Hashes.txt
find $computername -type f \( ! -name Processing_Details_and_Hashes.txt \) -exec shasum -a 256 {} \; >> $computername/Processing_Details_and_Hashes.txt
echo “Computing hashes of files”



# I don't want this in there quite yet for i in `ps aux | awk '{print $2}'`; do vmmap $i >> $computername/Memory_Mapping_$i.txt ; done



#LIST_OF_ALL_UPDATES
#Version 1.4 Due to a coding oversight, I forgot to put "LiveResponseData" in the file path. Thanks very much to Cristina Roura for pointing that out!
#Version 1.3 Added automated MD5 and SHA256 file hashing of all output files, saved as “Processing_Details_and_Hashes.txt”
exit
